\name{fregre.pc}
\Rdversion{1.1}
\alias{fregre.pc}
\title{ Functional Regression with scalar response using Principal Components Analysis.}
\description{
Computes functional (ridge or penalized) regression between functional explanatory variable \eqn{X(t)} and scalar response \eqn{Y} using Principal Components Analysis. 	

\deqn{Y=\big<X,\beta\big>+\epsilon=\int_{T}{X(t)\beta(t)dt+\epsilon}}{Y=<X,\beta>+\epsilon}

where \eqn{ \big<  \cdot , \cdot \big>}{<.,.>} denotes the inner product on \eqn{L_2} and \eqn{\epsilon} are random errors with mean zero , finite variance \eqn{\sigma^2} and \eqn{E[X(t)\epsilon]=0}{E[X(t)\epsilon]=0}.
 
}
\usage{
fregre.pc(fdataobj, y, l =NULL,lambda=0,P=c(1,0,0),
 weights = rep(1, len = n),...)
%fregre.pc(fdataobj, y, l = NULL,rn = 0,weights= rep(1,len=n),...) 
}

\arguments{
%  \item{fdataobj}{ \code{\link{fdata}} class object.}  
\item{fdataobj}{ \code{\link{fdata}} class object or \code{fdata.comp} class object created\cr
 by \code{\link{create.pc.basis}} function.}  
	\item{y}{ Scalar response with length \code{n}.}
  \item{l}{ Index of components to include in the model.If is null \code{l} (by default), \code{l=1:3}.}
  \item{lambda}{ Amount of penalization. Default value is 0, i.e. no penalization is used.}
  \item{P}{ If \code{P} is a vector:  \code{P} are coefficients to define the penalty matrix object, see \code{\link{P.penalty}}. If \code{P} is a matrix: P is the penalty matrix object.} 
  \item{weights}{ weights}
  \item{\dots}{ Further arguments passed to or from other methods.} 
}


\details{ 
The function computes the \eqn{\left\{\nu_k\right\}_{k=1}^{\infty}}{\nu_1,...,\nu_\infty} orthonormal basis of functional principal components to represent the functional data as \eqn{X_i(t)=\sum_{k=1}^{\infty}\gamma_{ik}\nu_k}{X(t)=\sum_(k=1:\infty) \gamma_k \nu_k} and the functional parameter as \eqn{\beta(t)=\sum_{k=1}^{\infty}\beta_k\nu_k}{\beta(t)=\sum_(k=1:\infty) \beta_k \nu_k}, where \eqn{\gamma_{ik}=\Big< X_i(t),\nu_k\Big>}{\gamma_k= < X(t), \nu_k >} and \eqn{\beta_{k}=\Big<\beta,\nu_k\Big>}{\beta_k=<\beta,\nu_k>}. \cr

The response can be fitted by:
\itemize{
\item \eqn{\lambda=0}{\lambda=0}, no penalization, \deqn{\hat{y}=\nu_k^{\top}(\nu_k^{\top}\nu_k)^{-1}\nu_k^{\top}y}{y.est= \nu'(\nu'\nu)^{-1}\nu'y}

\item Ridge regression, \eqn{\lambda>0}{\lambda>0} and \eqn{P=1}{P=1}, \deqn{\hat{y}=\nu_k^{\top}(\nu_k\top \nu_k+\lambda I)^{-1}\nu_k^{\top}y}{y.est=\nu'(\nu'\nu+\lambda I)^{-1}\nu'y}

\item Penalized regression, \eqn{\lambda>0}{\lambda>0} and \eqn{P\neq0}{P!=0}. For example, \eqn{P=c(0,0,1)}{P=c(0,0,1)} penalizes the second derivative (curvature) by \code{P=P.penalty(fdataobj["argvals"],P)}, \deqn{\hat{y}=\nu_k^{\top}(\nu_k\top \nu_k+\lambda \nu_k^{\top} \textbf{P}\nu_k)^{-1}\nu_k^{\top}y}{y.est=\nu'(\nu'\nu+\lambda v'Pv)^{-1}\nu'y}
}
}
\value{
Return:\cr
\item{call}{ The matched call of \code{\link{fregre.pc}} function.}
\item{coefficients}{ A named vector of coefficients.}
\item{residuals}{ \code{y}-\code{fitted values}.}
\item{fitted.values}{  Estimated scalar response.}
\item{beta.est}{ beta coefficient estimated of class \code{fdata}}
%\item{a.est}{ Intercept parameter estimated}
\item{df}{ The residual degrees of freedom. In ridge regression, \code{df(rn)} is the effective degrees of freedom.}
\item{r2}{ Coefficient of determination.}
%\item{GCV}{ GCV criterion.}
\item{sr2}{ Residual variance.}
\item{Vp}{ Estimated covariance matrix for the parameters.}
\item{H}{ Hat matrix.}
\item{l}{ Index of principal components selected.}
\item{lambda}{ Amount of shrinkage.}
\item{P}{ Penalty matrix.}
\item{fdata.comp}{ Fitted object in \code{\link{fdata2pc}} function.}
\item{lm}{ \code{lm} object.}
\item{fdataobj}{ Functional explanatory data.}
\item{y}{ Scalar response.}
}

\references{
Cai TT, Hall P. 2006. \emph{Prediction in functional linear regression}. Annals of Statistics 34: 2159{-}2179.

Cardot H, Ferraty F, Sarda P. 1999. \emph{Functional linear model}. Statistics and Probability Letters 45: 11{-}22.

Hall P, Hosseini{-}Nasab M. 2006. \emph{On properties of functional principal components analysis}. Journal of the Royal Statistical Society B 68: 109{-}126.

Febrero-Bande,  M., Oviedo de la Fuente, M. (2012).  \emph{Statistical Computing in Functional Data Analysis: The R Package fda.usc.}
Journal of Statistical Software, 51(4), 1-28. \url{http://www.jstatsoft.org/v51/i04/}

N. Kraemer, A.-L. Boulsteix, and G. Tutz (2008). \emph{Penalized Partial Least Squares with Applications to B-Spline Transformations and Functional Data}. Chemometrics and Intelligent Laboratory Systems, 94, 60 - 69. \url{http://dx.doi.org/10.1016/j.chemolab.2008.06.009}

}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente \email{manuel.oviedo@usc.es}
}
\seealso{
See Also as:   \code{\link{fregre.pc.cv}}, \code{\link{summary.fregre.fd}} and \code{\link{predict.fregre.fd}}.\cr
Alternative method: \code{\link{fregre.basis}} and   \code{\link{fregre.np}}.
}
\examples{
\dontrun{
data(tecator)
absorp=tecator$absorp.fdata
ind=1:129
x=absorp[ind,]
y=tecator$y$Fat[ind]
res=fregre.pc(x,y)
summary(res)
res2=fregre.pc(x,y,l=c(1,3,4))
summary(res2)
# Functional Ridge Regression
res3=fregre.pc(x,y,l=c(1,3,4),lambda=1,P=1)
summary(res3)
# Functional Regression with 2nd derivative penalization
res4=fregre.pc(x,y,l=c(1,3,4),lambda=1,P=c(0,0,1))
summary(res4)
betas<-c(res$beta.est,res2$beta.est,res3$beta.est,res4$beta.est)
plot(betas)
}
}
\keyword{regression}