% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_set.R
\name{SparseSet}
\alias{SparseSet}
\title{R6 class for a fuzzy set with sparse internal representation}
\description{
This class implements the data structure and methods for fuzzy sets.
}
\examples{
S <- SparseSet$new(attributes = c("A", "B", "C"))
S$assign(A = 1)
print(S)
S$to_latex()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SparseSet$new()}}
\item \href{#method-assign}{\code{SparseSet$assign()}}
\item \href{#method-[}{\code{SparseSet$[()}}
\item \href{#method-cardinal}{\code{SparseSet$cardinal()}}
\item \href{#method-get_vector}{\code{SparseSet$get_vector()}}
\item \href{#method-get_attributes}{\code{SparseSet$get_attributes()}}
\item \href{#method-length}{\code{SparseSet$length()}}
\item \href{#method-print}{\code{SparseSet$print()}}
\item \href{#method-to_latex}{\code{SparseSet$to_latex()}}
\item \href{#method-clone}{\code{SparseSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creator for objects of class \code{SparseSet}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$new(attributes, M = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attributes}}{(character vector) Names of the attributes that will be available in the fuzzy set.}

\item{\code{M}}{(numeric vector or column \code{Matrix}) Values (grades) to be assigned to the attributes.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If \code{M} is omitted, the fuzzy set is the empty set. Later, one can use the \code{assign} method to assign grades to any of its attributes.
}

\subsection{Returns}{
An object of class \code{SparseSet}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assign"></a>}}
\if{latex}{\out{\hypertarget{method-assign}{}}}
\subsection{Method \code{assign()}}{
Assign grades to attributes in the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$assign(attributes = c(), values = c(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attributes}}{(character vector) Names of the attributes to assign a grade to.}

\item{\code{values}}{(numeric vector) Grades to be assigned to the previous \code{attributes}.}

\item{\code{...}}{\code{key} = \code{value} pairs, where the value \code{value} is assigned to the \code{key} attribute name.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
One can use both of:
\code{S$assign(A = 1, B = 0.3)}
\code{S$assign(attributes = c(A, B), values = c(1, 0.3))}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-["></a>}}
\if{latex}{\out{\hypertarget{method-[}{}}}
\subsection{Method \code{[()}}{
Get elements by index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$[(indices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{(numeric, logical or character vector) The indices of the elements to return. It can be a vector of logicals where \code{TRUE} elements are to be retained.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{SparseSet} but with only the required elements.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cardinal"></a>}}
\if{latex}{\out{\hypertarget{method-cardinal}{}}}
\subsection{Method \code{cardinal()}}{
Cardinal of the SparseSet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$cardinal()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the cardinal of the \code{SparseSet}, counted
as the sum of the degrees of each element.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_vector"></a>}}
\if{latex}{\out{\hypertarget{method-get_vector}{}}}
\subsection{Method \code{get_vector()}}{
Internal \code{Matrix}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$get_vector()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The internal sparse \code{Matrix} representation of the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Attributes defined for the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$get_attributes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with the names of the attributes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length"></a>}}
\if{latex}{\out{\hypertarget{method-length}{}}}
\subsection{Method \code{length()}}{
Number of attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of attributes that are defined for this fuzzy set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints the set to console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the elements of the set and their grades between brackets {}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Write the set in LaTeX format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$to_latex(print = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The fuzzy set in LaTeX.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
