% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.methods.R
\name{plot.fbroc.roc}
\alias{plot.fbroc.roc}
\title{Plots a \code{fbroc.roc} object}
\usage{
\method{plot}{fbroc.roc}(x, col = "blue", fill = "royalblue1",
  print.plot = TRUE, show.conf = TRUE, conf.level = 0.95,
  show.metric = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{fbroc.roc}.}

\item{col}{Color used for the curve. Defaults to blue.}

\item{fill}{Color used for the confidence region. Defaults to royalblue1.}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{show.conf}{Logical specifying whether the confidence region should be
plotted.}

\item{conf.level}{Confidence level of the confidence region.}

\item{show.metric}{Character specifying which metric to display. See
\code{\link{perf.roc}} for details. Defaults to \code{NULL}, which means
that no metric is displayed.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Plot a \code{fbroc.roc} object and shows the ROC curve. The confidence
region for the ROC curve and the result for a specified performance metric
can also be included in the plot.
}
\examples{
y <- rep(c(TRUE, FALSE), each = 500)
x <- rnorm(1000) + y
result.boot <- boot.roc(x, y, n.boot = 100)
plot(result.boot)
}
\seealso{
\code{\link{boot.roc}}, \code{\link{perf.roc}}
}

