% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/package.R
\docType{package}
\name{fasterize}
\alias{fasterize}
\title{Rasterize an sf object of polygons}
\usage{
fasterize(
  sf,
  raster,
  field = NULL,
  fun = "last",
  background = NA_real_,
  by = NULL
)
}
\arguments{
\item{sf}{an \code{\link[sf:sf]{sf::sf()}} object with a geometry column of POLYGON and/or
MULTIPOLYGON objects.}

\item{raster}{A raster  object. Used as a template for the raster output.
Can be created with \code{\link[raster:raster]{raster::raster()}}.
The fasterize package provides a method to create a raster object from
an sf object.}

\item{field}{character. The name of a column in \code{sf},
providing a value for each of the polygons rasterized. If NULL (default),
all polygons will be given a value of 1.}

\item{fun}{character. The name of a function by which to combine overlapping
polygons. Currently takes "sum", "first", "last", "min", "max", "count", or
"any".  Future versions may include more functions or the ability to pass
custom R/C++ functions. If you need to summarize by a different function,
use \verb{by=} to get a RasterBrick and then \code{\link[raster:stackApply]{raster::stackApply()}} or
\code{\link[raster:calc]{raster::calc()}} to summarize.}

\item{background}{numeric. Value to put in the cells that are not covered by
any of the features of x. Default is NA.}

\item{by}{character.  The name of a column in \code{sf} by which to aggregate
layers.  If set, fasterize will return a RasterBrick with as many layers
as unique values of the \code{by} column.}
}
\value{
A raster of the same size, extent, resolution and projection as the
provided raster template.
}
\description{
Rasterize set of polygons

Fast sf-to-raster conversion
}
\details{
This is a high-performance replacement for \code{\link[raster:rasterize]{raster::rasterize()}}.

The algorithm is based on the method described in course materials provided
by \href{https://labs.wsu.edu/wayne-cochran/}{Wayne O. Cochran}. The algorithm
is originally attributed to
Wylie et al. (1967) \doi{10.1145/1465611.1465619}.
}
\examples{
library(sf)
library(fasterize)
p1 <- rbind(c(-180,-20), c(-140,55), c(10, 0), c(-140,-60), c(-180,-20))
hole <- rbind(c(-150,-20), c(-100,-10), c(-110,20), c(-150,-20))
p1 <- list(p1, hole)
p2 <- list(rbind(c(-10,0), c(140,60), c(160,0), c(140,-55), c(-10,0)))
p3 <- list(rbind(c(-125,0), c(0,60), c(40,5), c(15,-45), c(-125,0)))
pols <- st_sf(value = rep(1,3),
              geometry = st_sfc(lapply(list(p1, p2, p3), st_polygon)))
r <- raster(pols, res = 1)
r <- fasterize(pols, r, field = "value", fun="sum")
plot(r)
}
\references{
Wylie, C., Romney, G., Evans, D., & Erdahl, A. (1967).
Half-tone perspective drawings by computer. Proceedings of the November
14-16, 1967, Fall Joint Computer Conference. AFIPS '67 (Fall).
\doi{10.1145/1465611.1465619}
}
