% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnb.io.R
\name{fnb.save}
\alias{fnb.save}
\alias{fnb.save.default}
\alias{fnb.load}
\alias{fnb.load.default}
\title{Save & Load Function for Fast Naive Bayes Models}
\usage{
fnb.save(model, filename, overwrite = FALSE)

\method{fnb.save}{default}(model, filename, overwrite = FALSE)

fnb.load(filename)

\method{fnb.load}{default}(filename)
}
\arguments{
\item{model}{the fitted Naive Bayes model to save.}

\item{filename}{the file name to use to save or load the model.}

\item{overwrite}{Whether to allow overwriting of previously saved models.}
}
\value{
fnb.save returns the filename that was used, and fnb.load returns the saved object.
}
\description{
Loads and saves fitted Naive Bayes models.
}
\examples{
rm(list = ls())
library(fastNaiveBayes)
cars <- mtcars
y <- as.factor(ifelse(cars$mpg > 25, "High", "Low"))
x <- cars[,2:ncol(cars)]

mod <- fastNaiveBayes(x, y, laplace = 1)
fnb.save(mod, "fastNaiveBayesModel")
mod2 <- fnb.load("fastNaiveBayesModel")
identical(mod, mod2)
file.remove("fastNaiveBayesModel")

}
