% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{mat_to_fmm}
\alias{mat_to_fmm}
\title{Convert a Numeric Matrix to Matrix Market Format}
\arguments{
\item{input}{A numeric matrix to be converted.}

\item{filename}{The name of the output file where the Matrix Market formatted
data will be saved.}
}
\value{
A boolean indicating success or failure. Writes a MTX file to disk.
}
\description{
This function takes a numeric matrix and converts it into a
Matrix Market file.
}
\examples{
mat <- matrix(c(1, 2, 3, 4), nrow = 2)
mat_to_fmm(mat, tempfile(fileext = ".mtx"))
}
