% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_nnls.R
\name{cov_nnls}
\alias{cov_nnls}
\title{Estimate non-negative diagonal terms on G matrix}
\usage{
cov_nnls(
  data,
  L,
  out_index,
  data_cov,
  RE_table,
  idx_lst,
  designmat,
  betaHat,
  GTilde,
  non_neg = 0,
  silent = TRUE
)
}
\arguments{
\item{data}{Data frame containing all predictor and outcome variables}

\item{L}{The dimension of the functional domain}

\item{out_index}{Indices of outcome variables in `data`}

\item{data_cov}{(unsure) Covariance of variables}

\item{RE_table}{Data frame containing random effects and interactions}

\item{idx_lst}{(unsure) Column indices of random effects}

\item{designmat}{(unsure)}

\item{betaHat}{Estimates of coefficients of random effects}

\item{GTilde}{Current `GTilde` estimate, created as an intermediate in `G_estimate`}

\item{non_neg}{(unsure), defaults to 0}

\item{silent}{Whether to print the step. Defaults to `TRUE`.}
}
\value{
A matrix with the same dimensions as `GTilde`.
}
\description{
Helper function for `G_estimate`. Uses least squares under non-negativity
constraints, mainly relying on `nnls` capability from `lsei`.
}
