/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.LPX;
import jfm.model.Types;
import jfm.model.Worker;
import jfm.xml.XMLSyntaxException;

public class Machine
extends Worker {
    private double annualCost;
    private LPX glpkVType;

    public Machine copy() {
        Machine newm = null;
        try {
            newm = new Machine(this.type, this.annualCost, this.glpkVType);
        }
        catch (XMLSyntaxException ex) {
            throw new Error("Invalid match between machine type and subtype");
        }
        return newm;
    }

    public double getAnnualCost() {
        return this.annualCost;
    }

    private Machine(Types.WorkerType type_, double annualCost_, LPX glpkVType_) throws XMLSyntaxException {
        super(type_, Types.xmlToWorkerSubType(type_.xmlname), glpkVType_, 0.0, 0.0, LPX.LPX_LO);
        this.annualCost = annualCost_;
        this.glpkVType = glpkVType_;
    }

    public Machine(Types.WorkerType type_, double purchaseCost, int replace, double depRate, double repair, LPX glpkVType) throws XMLSyntaxException {
        super(type_, Types.xmlToWorkerSubType(type_.xmlname), glpkVType, 0.0, 0.0, LPX.LPX_LO);
        double depValue = purchaseCost;
        for (int i = 0; i < replace; ++i) {
            depValue -= depValue * (depRate * 0.01);
        }
        double lifetimeCost = purchaseCost - depValue + repair * 0.01 * purchaseCost * (double)replace;
        this.annualCost = lifetimeCost / (double)replace;
    }
}

