% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParseSettings.R
\name{.parse_model_development_settings}
\alias{.parse_model_development_settings}
\title{Internal function for parsing settings related to model development}
\usage{
.parse_model_development_settings(
  config = NULL,
  data,
  parallel,
  outcome_type,
  learner = waiver(),
  hyperparameter = waiver(),
  novelty_detector = waiver(),
  detector_parameters = waiver(),
  parallel_model_development = waiver(),
  ...
)
}
\arguments{
\item{config}{A list of settings, e.g. from an xml file.}

\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{parallel}{Logical value that whether familiar uses parallelisation. If
\code{FALSE} it will override \code{parallel_model_development}.}

\item{outcome_type}{Type of outcome found in the data set.}

\item{learner}{(\strong{required}) One or more algorithms used for model
development. A sizeable number learners is supported in \code{familiar}. Please
see the vignette on learners for more information concerning the available
learners.}

\item{hyperparameter}{(\emph{optional}) List of lists containing hyperparameters
for learners. Each sublist should have the name of the learner method it
corresponds to, with list elements being named after the intended
hyperparameter, e.g. \code{"glm_logistic"=list("sign_size"=3)}

All learners have hyperparameters. Please refer to the vignette on learners
for more details. If no parameters are provided, sequential model-based
optimisation is used to determine optimal hyperparameters.

Hyperparameters provided by the user are never optimised. However, if more
than one value is provided for a single hyperparameter, optimisation will
be conducted using these values.}

\item{novelty_detector}{(\emph{optional}) Specify the algorithm used for training
a novelty detector. This detector can be used to identify
out-of-distribution data prospectively.}

\item{detector_parameters}{(\emph{optional}) List lists containing hyperparameters
for novelty detectors. Currently not used.}

\item{parallel_model_development}{(\emph{optional}) Enable parallel processing for
the model development workflow. Defaults to \code{TRUE}. When set to \code{FALSE},
this will disable the use of parallel processing while developing models,
regardless of the settings of the \code{parallel} parameter.
\code{parallel_model_development} is ignored if \code{parallel=FALSE}.}

\item{...}{Unused arguments.}
}
\value{
List of parameters related to model development.
}
\description{
Internal function for parsing settings related to model development
}
\keyword{internal}
