% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{familiarModel-class}
\alias{familiarModel-class}
\title{Familiar model.}
\description{
A familiarModel object is a self-contained model that can be applied to
generate predictions for a dataset. familiarModel objects form the parent
class of learner-specific child classes.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the familiarModel object.}

\item{\code{model}}{The actual model trained using a specific algorithm, e.g. a
random forest from the `ranger` package, or a LASSO model from `glmnet`.}

\item{\code{outcome_type}}{Outcome type of the data used to create the object.}

\item{\code{outcome_info}}{Outcome information object, which contains additional
information concerning the outcome, such as class levels.}

\item{\code{feature_info}}{List of objects containing feature information, e.g.,
name, class levels, transformation, normalisation and clustering
parameters.}

\item{\code{data_column_info}}{Data information object containing information
regarding identifier column names and outcome column names.}

\item{\code{hyperparameters}}{Set of hyperparameters used to train the model.}

\item{\code{hyperparameter_data}}{Information generated during hyperparameter
optimisation.}

\item{\code{calibration_model}}{One or more models used to recalibrate the model
output. Currently only used by some models.}

\item{\code{novelty_detector}}{A familiarNoveltyDetector object that can be used to
detect out-of-distribution samples.}

\item{\code{learner}}{Learning algorithm used to create the model.}

\item{\code{fs_method}}{Feature selection method used to determine variable
importance for the model.}

\item{\code{required_features}}{The set of features required for complete
reproduction, i.e. with imputation.}

\item{\code{model_features}}{The set of features that is used to train the model,}

\item{\code{novelty_features}}{The set of features that is used to train all novelty
detectors in the ensemble.}

\item{\code{calibration_info}}{Calibration information, e.g. baseline survival in the
development cohort.}

\item{\code{km_info}}{Data concerning stratification into risk groups.}

\item{\code{run_table}}{Run table for the data used to train the model. Used
internally.}

\item{\code{settings}}{A copy of the evaluation configuration parameters used at
model creation. These are used as default parameters when evaluating the
model (technically, familiarEnsemble) to create a familiarData object.}

\item{\code{is_trimmed}}{Flag that indicates whether the model, stored in the `model`
slot, has been trimmed.}

\item{\code{trimmed_function}}{List of functions whose output has been captured prior
to trimming the model.}

\item{\code{messages}}{List of warning and error messages generated during training.}

\item{\code{project_id}}{Identifier of the project that generated the familiarModel
object.}

\item{\code{familiar_version}}{Version of the familiar package.}

\item{\code{package}}{Name of package(s) required to executed the model itself, e.g.
`ranger` or `glmnet`.}

\item{\code{package_version}}{Version of the packages mentioned in the `package`
attribute.}
}}

