% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_acc_parity}
\alias{eval_acc_parity}
\title{Examine Accuracy Parity of a Model}
\usage{
eval_acc_parity(
  data,
  outcome,
  group,
  probs,
  cutoff = 0.5,
  confint = TRUE,
  alpha = 0.05,
  bootstraps = 2500,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable}

\item{group}{Name of the sensitive attribute}

\item{probs}{Predicted probabilities}

\item{cutoff}{Cutoff value for the predicted probabilities}

\item{confint}{Logical indicating whether to calculate confidence intervals}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{bootstraps}{Number of bootstraps to use for confidence intervals}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Logical; if TRUE (default), prints a textual summary of the
fairness evaluation. Only works if \code{confint} is TRUE.}
}
\value{
A list containing the following elements:
\itemize{
\item Accuracy for Group 1
\item Accuracy for Group 2
\item Difference in accuracy
\item Ratio in accuracy
If confidence intervals are computed (\code{confint = TRUE}):
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the difference in accuracy
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the ratio in accurac
}
}
\description{
This function assesses \emph{Accuracy Parity}, a fairness criterion that evaluates whether
the overall accuracy of a predictive model is consistent across different groups.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.
# We choose threshold = 0.41 so that the overall FPR is around 5\%.

# Evaluate Accuracy Parity
eval_acc_parity(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred",
  cutoff = 0.41
)
}

}
\seealso{
\code{\link{eval_cond_acc_equality}}
}
