# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title PACalculationColumn
#' @description PACalculationColumn Class
#' @format An \code{R6Class} generator object
#' @field id  character [optional]
#'
#' @field statistics  list( character ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
PACalculationColumn <- R6::R6Class(
  'PACalculationColumn',
  public = list(
    `id` = NULL,
    `statistics` = NULL,
    initialize = function(`id`=NULL, `statistics`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`id`)) {
        stopifnot(is.character(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!is.null(`statistics`)) {
        stopifnot(is.vector(`statistics`), length(`statistics`) != 0)
        sapply(`statistics`, function(x) stopifnot(is.character(x)))
        self$`statistics` <- `statistics`
      }
    },
    toJSON = function() {
      PACalculationColumnObject <- list()
      if (!is.null(self$`id`)) {
        PACalculationColumnObject[['id']] <-
          self$`id`
      }
      if (!is.null(self$`statistics`)) {
        PACalculationColumnObject[['statistics']] <-
          self$`statistics`
      }

      PACalculationColumnObject
    },
    fromJSON = function(PACalculationColumnJson) {
      PACalculationColumnObject <- jsonlite::fromJSON(PACalculationColumnJson)
      if (!is.null(PACalculationColumnObject$`id`)) {
        self$`id` <- PACalculationColumnObject$`id`
      }
      if (!is.null(PACalculationColumnObject$`statistics`)) {
        self$`statistics` <- ApiClient$new()$deserializeObj(PACalculationColumnObject$`statistics`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`id`)) {
        sprintf(
        '"id":
          "%s"
                ',
        self$`id`
        )},
        if (!is.null(self$`statistics`)) {
        sprintf(
        '"statistics":
           [%s]
        ',
        paste(unlist(lapply(self$`statistics`, function(x) paste0('"', x, '"'))), collapse=",")
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(PACalculationColumnJson) {
      PACalculationColumnObject <- jsonlite::fromJSON(PACalculationColumnJson)
      self$`id` <- PACalculationColumnObject$`id`
      self$`statistics` <- ApiClient$new()$deserializeObj(PACalculationColumnObject$`statistics`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
