% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{corplot}
\alias{corplot}
\title{Plots pairwise correlations over time}
\usage{
corplot(
  x,
  fsvsimobj = NULL,
  these = 1:(ncol(x$y) * (ncol(x$y) - 1)/2),
  start = 1,
  end = nrow(x$y),
  maxrows = 10,
  ...
)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{fsvsimobj}{To indicate data generating values in case of simulated
data, pass an object of type \code{fsvsim} (usually the result of a
call to \code{\link{fsvsim}}).}

\item{these}{Indicator which correlations should be plotted. Default is all.}

\item{start}{First point in time to plot.}

\item{end}{Last point in time to plot.}

\item{maxrows}{The maximum number of rows per page.}

\item{...}{Other arguments will be passed on to \code{\link[stats]{ts.plot}}.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{corplot} gives an overview of (certain) pairwise correlations.
Throws a warning if these haven't been stored during sampling.
}
\seealso{
Other plotting: 
\code{\link{comtimeplot}()},
\code{\link{corimageplot}()},
\code{\link{cortimeplot}()},
\code{\link{evdiag}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{facloadtraceplot}()},
\code{\link{logvartimeplot}()},
\code{\link{paratraceplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()},
\code{\link{voltimeplot}()}
}
\concept{plotting}
