% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power23_13.R
\name{power23_13}
\alias{power23_13}
\title{Power of the 2/3-1/3 procedure}
\usage{
power23_13(n, hrA, hrB, hrAB, avgprob, probAB_C, crit23A, crit23ab, dig,
  cormat = matrix(c(1, sqrt(0.5), sqrt(0.5), 1), byrow = TRUE, nrow = 2),
  niter = 5, abseps = 0.001)
}
\arguments{
\item{n}{total subjects with n/4 subjects in each of the C, A, B, and AB groups}

\item{hrA}{group A to group C hazard ratio; \code{hrA} < 1 corresponds to group A superiority}

\item{hrB}{group B to group C hazard ratio; \code{hrA} < 1 corresponds to group A superiority}

\item{hrAB}{group AB to group C hazard ratio; \code{hrAB} < 1 corresponds to group AB superiority}

\item{avgprob}{event probability averaged across the C, A, B, and AB groups}

\item{probAB_C}{event probability averaged across the AB and C groups}

\item{crit23A}{rejection critical value for the overall A stratified logrank statistic}

\item{crit23ab}{rejection critical value for the simple AB ordinary logrank statistic}

\item{dig}{number of decimal places to which we \code{\link{roundDown}} the critical value
for the overall A test as calculated in \code{\link{power23_13}}
by \code{\link{strLgrkPower}}}

\item{cormat}{asymptotic correlation matrix for the overall A and simple AB logrank statistics}

\item{niter}{number of times we call \code{pmvnorm} to average out its randomness}

\item{abseps}{\code{abseps} setting in the \code{pmvnorm} call}
}
\value{
\item{poweroverA }{power to detect the overall A effect}

\item{powerAB }{power to detect the simple AB effect}

\item{poweroverAandAB }{power to detect the overall A and simple AB effects}

\item{power23.13 }{power to detect the overall A or simple AB effects, i.e., power of the 2/3-1/3 procedure}
}
\description{
Computes the power of the 2/3-1/3 procedure, that is, the power to
detect the overall A effect or the simple AB effect.
}
\details{
The 2/3-1/3 procedure uses a  two-sided
2/3 * alpha = 0.033 significance level to test the overall A effect.
When  the familywise error is alpha = 0.05, this corresponds to a
critical value \code{crit23A} = -2.13.
Then \code{\link{crit2x2}} is used to compute a critical value
\code{crit23ab} = -2.24 to test the simple AB effect.  This corresponds to
a two-sided 0.0251 significance level.  This controls the
asymptotic familywise type I error for the two hypothesis tests at the
two-sided 0.05 level.  This is because of the \code{1/sqrt(2)} asymptotic
correlation between the logrank test statistics for the overall A
and simple AB effects (Slud, 1994).  The overall A effect's significance
level 2/3 * 0.05 is prespecified and the simple AB effect's significance
level 0.0251 is computed using \code{crit2x2}.
The \code{pmvnorm} function
from the \code{mvtnorm} package is used to calculate
the power that both (intersection) the overall A and simple AB effects are detected.
Since this involves bivariate normal integration over an unbounded region in R^2, \code{pmvnorm}
uses a random seed for this computation.  To smooth out the
randomness, \code{pmvnorm} is called \code{niter} times and
the average value over the \code{niter} calls is taken to be that power.
}
\examples{
 # Corresponds to scenario 5 in Table 2 from Leifer, Troendle, et al. (2019).
 rateC <- 0.0445  # one-year C group event rate
 hrA <- 0.80
 hrB <- 0.80
 hrAB <- 0.72
 mincens <- 4.0
 maxcens <- 8.4
 eventvec <- eventProb(rateC, hrA, hrB, hrAB, mincens, maxcens)
 avgprob <- eventvec$avgprob
 probAB_C <- 0.5 * (eventvec$probAB + eventvec$probC)
 dig <- 2
 alpha <- 0.05
 corAa  <- 1/sqrt(2)
 corAab <- 1/sqrt(2)
 coraab <- 1/2
 critvals <- crit2x2(corAa, corAab, coraab, dig, alpha)
 crit23A <- critvals$crit23A
 crit23ab <- critvals$crit23ab
 n <- 4600
 power23_13(n, hrA, hrB, hrAB, avgprob, probAB_C,
            crit23A, crit23ab, dig, cormat =
            matrix(c(1, sqrt(0.5), sqrt(0.5), 1), byrow = TRUE,
            nrow = 2), niter = 1, abseps = 1e-03)
# $poweroverA
# [1] 0.6582819

# $powerAB
# [1] 0.9197286

# $poweroverAandAB
# [1] 0.6490042

# $power23.13
# [1] 0.9290062
}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. (2019). Submitted.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\seealso{
\code{crit2x2}, \code{eventProb}, \code{lgrkPower}, \code{strLgrkPower}, \code{pmvnorm}
}
\author{
Eric Leifer, James Troendle
}
