% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac2x2design.R
\name{fac2x2design}
\alias{fac2x2design}
\title{Power for the 2/3-1/3, 1/3-1/3-1/3, 1/2-1/2 procedures}
\usage{
fac2x2design(n, rateC, hrA, hrB, hrAB, mincens, maxcens, dig = 2,
  alpha = 0.05, niter = 5, abseps = 0.001, corAa = 1/sqrt(2),
  corAab = 1/sqrt(2), coraab = 1/2)
}
\arguments{
\item{n}{total sample size}

\item{rateC}{group C one year event rate}

\item{hrA}{group A to group C hazard ratio}

\item{hrB}{group B to group C hazard ratio}

\item{hrAB}{group AB to group C hazard ratio}

\item{mincens}{minimum censoring time}

\item{maxcens}{maximum censoring time}

\item{dig}{number of decimal places to \code{\link{roundDown}} the critical value to}

\item{alpha}{two-sided significance level}

\item{niter}{number of times we call \code{pmvnorm} to average out its randomness}

\item{abseps}{\code{abseps} setting in the \code{pmvnorm} call}

\item{corAa}{correlation between the overall A and simple A log hazard ratio estimates}

\item{corAab}{correlation between the overall A and simple AB log hazard ratio estimates}

\item{coraab}{correalation between the simple A and simple AB log hazard ratio estimates}
}
\value{
\item{powerA}{power to detect the overall A effect at the two-sided \code{alpha} level}

\item{powerB}{power to detect the overall B effect at the two-sided \code{alpha} level}

\item{power23.13 }{power to detect the overall A or simple AB effects using the 2/3-1/3 procedure}

\item{power13.13.13 }{power to detect the overall A, simple A,  or simple AB effects using
the 1/3-1/3-1/3 procedure}

\item{power12.12 }{power to detect the simple A or simple AB effects using
the 1/2-1/2 procedure}

\item{events}{expected number of events}

\item{evtprob}{event probabilities for the C, A, B, and AB groups, respectively}
}
\description{
Power for the 2/3-1/3, 1/3-1/3-1/3, 1/2-1/2 procedures
}
\examples{
# Corresponds to scenario 5 in Table 2 from Leifer, Troendle, et al. (2019).
n <- 4600
rateC <- 0.0445
hrA <- 0.80
hrB <- 0.80
hrAB <- 0.72
mincens <- 4.0
maxcens <- 8.4

fac2x2design(n, rateC, hrA, hrB, hrAB, mincens, maxcens, dig = 2, alpha = 0.05, niter = 1)
# $powerA
# [1] 0.7182932

# $powerB
# [1] 0.7182932

# $power23.13
# [1] 0.9290062

# $power13.13.13
# [1] 0.9302078

# $power12.12
# [1] 0.9411688

# $events
# [1] 954.8738

# $evtprob
# probC     probA     probB    probAB
# 0.2446365 0.2012540 0.2012540 0.1831806

}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. (2019). Submitted.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\seealso{
\code{\link{eventProb}}, \code{\link{crit2x2}}, \code{\link{strLgrkPower}}
\code{\link{power23_13}}, \code{\link{power13_13_13}}, \code{\link{power12_12}}
}
