% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power13_13_13.R
\name{power13_13_13}
\alias{power13_13_13}
\title{Power of the 1/3-1/3-1/3 procedure}
\usage{
power13_13_13(n, hrA, hrB, hrAB, avgprob, probA_C, probAB_C, crit13, dig,
  cormat12 = matrix(c(1, sqrt(0.5), sqrt(0.5), 1), byrow = T, nrow = 2),
  cormat23 = matrix(c(1, 0.5, 0.5, 1), byrow = T, nrow = 2),
  cormat123 = matrix(c(1, sqrt(0.5), sqrt(0.5), sqrt(0.5), 1, 0.5,
  sqrt(0.5), 0.5, 1), byrow = T, nrow = 3), niter = 5, abseps = 0.001)
}
\arguments{
\item{n}{total subjects with n/4 subjects in each of the C, A, B, and AB groups}

\item{hrA}{group A to group C hazard ratio; \code{hrA} < 1 corresponds to group A superiority}

\item{hrB}{group B to group C hazard ratio; \code{hrA} < 1 corresponds to group A superiority}

\item{hrAB}{group AB to group C hazard ratio; \code{hrAB} < 1 corresponds to group AB superiority}

\item{avgprob}{event probability averaged across the C, A, B, and AB groups}

\item{probA_C}{event probability averaged across the A and C groups}

\item{probAB_C}{event probability averaged across the AB and C groups}

\item{crit13}{rejection critical value for the overall A, simple A, and simple AB logrank statistics}

\item{dig}{number of decimal places to \code{\link{roundDown}} the critical value to}

\item{cormat12}{asymptotic correlation matrix for the overall A and simple A, respectively, simple AB logrank statistics}

\item{cormat23}{asymptotic correlation matrix for the simple A and  simple AB logrank statistics}

\item{cormat123}{asymptotic correlation matrix for the overall A, simple A, and  simple AB logrank statistics}

\item{niter}{number of times we call \code{pmvnorm} to average out its randomness}

\item{abseps}{\code{abseps} setting in the \code{pmvnorm} call}
}
\value{
\item{poweroverA }{power to detect the overall A effect}

\item{powerA }{power to detect the simple A effect}

\item{powerAB }{power to detect the simple AB effect}

\item{power13.13.13 }{power to detect the overall A, simple A,  or simple AB effects, i.e.,
power of the 1/3-1/3-1/3 procedure}
}
\description{
Computes the power of the 1/3-1/3-1/3 procedure, that is, the power to
detect the overall A effect, the simple A effect, or the simple AB effect.
}
\details{
For a 2-by-2 factorial design, this function computes
the probability that either the overall A
or the simple A or the simple AB logrank statistics
reject their null hypotheses at the
\code{crit13} critical value.  As described in Leifer, Troendle, et al. (2019),
the \code{crit13} = -2.32 critical value
corresponds to controlling the famiywise error of the 1/3-1/3-1/3 procedure at the
two-sided 0.05 significance level.
The critical value -2.32 may be computed using the \code{crit2x2} function.
The \code{pmvnorm} function
from the \code{mvtnorm} package is used to calculate
the powers for rejecting the pairwise and three-way intersections of
Since these powers involve bivariate, respectively, trivariate,
 normal integration over an unbounded region in R^2, respectively, R^3, \code{pmvnorm}
uses a random seed for these computations.  To smooth out the
randomness, \code{pmvnorm} is called \code{niter} times and
the average value over the \code{niter} calls is taken to be those powers.
}
\examples{
# Corresponds to scenario 5 in Table 2 from Leifer, Troendle, et al. (2019).
rateC <- 0.0445
hrA <- 0.80
hrB <- 0.80
hrAB <- 0.72
mincens <- 4.0
maxcens <- 8.4
evtprob <- eventProb(rateC, hrA, hrB, hrAB, mincens, maxcens)
avgprob <- evtprob$avgprob
probAB_C <- evtprob$probAB_C
probA_C <- evtprob$probA_C
dig <- 2
alpha <- 0.05
corAa  <- 1/sqrt(2)
corAab <- 1/sqrt(2)
coraab <- 1/2
crit13 <- crit2x2(corAa, corAab, coraab, dig, alpha)$crit13
n <- 4600
power13_13_13(n, hrA, hrB, hrAB, avgprob, probA_C, probAB_C,
  crit13, dig, cormat12 = matrix(c(1, sqrt(0.5), sqrt(0.5), 1), byrow = TRUE,
  nrow = 2), cormat23 = matrix(c(1, 0.5, 0.5, 1), byrow = TRUE, nrow = 2),
  cormat123 = matrix(c(1, sqrt(0.5), sqrt(0.5), sqrt(0.5), 1, 0.5,
  sqrt(0.5), 0.5, 1), byrow=TRUE, nrow = 3), niter = 1, abseps = 1e-03)

# $poweroverA
# [1] 0.5861992

# $powerA
# [1] 0.5817954

# $powerAB
# [1] 0.9071236

# $power13.13.13
# [1] 0.9302078
}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. (2019). Submitted.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\seealso{
\code{\link{crit2x2}}, \code{lgrkPower}, \code{strLgrkPower}, \code{pmvnorm}
}
