% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{bias_adjust}
\alias{bias_adjust}
\title{Bias adjust back-transformation functions}
\usage{
bias_adjust(bt, sd)
}
\arguments{
\item{bt}{The back-transformation function}

\item{sd}{The forecast standard deviation}
}
\description{
To produce forecast means (instead of forecast medians) it is necessary to adjust the back-transformation function relative to the forecast variance.
}
\details{
More details about bias adjustment can be found in the transformations vignette: read the vignette:
\code{vignette("transformations", package = "fable")}
}
\examples{

adj_fn <- bias_adjust(function(x) exp(x), 1:10)
y <- rnorm(10)
exp(y)
adj_fn(y)

}
