% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croston.R
\name{tidy.croston}
\alias{tidy.croston}
\title{Tidy a fable model}
\usage{
\method{tidy}{croston}(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{...}{Additional arguments to tidying method.}
}
\value{
The model's coefficients in a \code{tibble}.
}
\description{
Returns the coefficients from the model in a \code{tibble} format.
}
\examples{
library(tsibble)
sim_poisson <- tsibble(
  time = yearmonth("2012 Dec") + seq_len(24),
  count = rpois(24, lambda = 0.3),
  index = time
)

sim_poisson \%>\%
  model(CROSTON(count)) \%>\%
  tidy()
}
