% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{residuals.RW}
\alias{residuals.RW}
\title{Extract residuals from a fable model}
\usage{
\method{residuals}{RW}(object, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A vector of fitted residuals.
}
\description{
Extracts the residuals.
}
\examples{
as_tsibble(Nile) \%>\%
  model(NAIVE(value)) \%>\%
  residuals()

library(tsibbledata)
aus_production \%>\%
  model(snaive = SNAIVE(Beer ~ lag("year"))) \%>\%
  residuals()
}
