% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{glance.ARIMA}
\alias{glance.ARIMA}
\title{Glance an ARIMA model}
\usage{
\method{glance}{ARIMA}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the ARIMA model.
}
\details{
Contains the variance of residuals (\code{sigma2}), the log-likelihood (\code{log_lik}),
information criterion (\code{AIC}, \code{AICc}, \code{BIC}) and the characteristic roots
(\code{ar_roots} and \code{ma_roots}).
}
\examples{
USAccDeaths \%>\% 
  as_tsibble \%>\% 
  model(arima = ARIMA(log(value) ~ pdq(0,1,1) + PDQ(0,1,1))) \%>\% 
  glance()

}
