% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_sdds.R
\name{fHMM_sdds}
\alias{fHMM_sdds}
\alias{print.fHMM_sdds}
\title{Define state-dependent distributions}
\usage{
fHMM_sdds(sdds)

\method{print}{fHMM_sdds}(x, ...)
}
\arguments{
\item{sdds}{A \code{character} (vector) of length two that can be specified for
\code{"sdds"} in \code{\link{set_controls}}.}

\item{...}{Currently not used.}
}
\value{
A \code{list} of length \code{length(sdds)}.
Each element again is a \code{list}, containing
\itemize{
\item the \code{"name"} of the distribution
\item and a list \code{"pars"} of its parameters, where unknown parameters are
set to \code{NULL}.
}
}
\description{
This helper function defines state-dependent distributions for the \{fHMM\}
package.
}
\examples{
\dontrun{
sdds <- c("t(sigma = 0.1, df = Inf)", "gamma", "lnorm(mu = 1)")
fHMM_sdds(sdds)
}

}
\keyword{internal}
