% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\docType{data}
\name{sim_model_2gamma}
\alias{sim_model_2gamma}
\title{Simulated 2-state HMM}
\format{
An object of class \code{fHMM_model}.
}
\usage{
data("sim_model_2gamma")
}
\description{
A pre-computed 2-state HMM with state-dependent gamma distributions with means
fixed to \code{0.5} and \code{2} on \code{500} simulated observations.
}
\details{
The model was estimated via:
\preformatted{
controls <- list(
  states  = 2,
  sdds    = "gamma(mu = 1|2)",
  horizon = 200,
  fit     = list(runs = 50)
)
controls <- set_controls(controls)
pars <- fHMM_parameters(
  controls = controls, Gamma = matrix(c(0.9,0.2,0.1,0.8), nrow = 2),
  sigmas = c(0.5,1)
)
data <- prepare_data(controls, true_parameters = pars, seed = 1)
sim_model_2gamma <- fit_model(data, seed = 1, verbose = FALSE)
}
}
\keyword{model}
