% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_states.R
\name{reorder_states}
\alias{reorder_states}
\title{Reordering of estimated states}
\usage{
reorder_states(x, state_order)
}
\arguments{
\item{x}{An object of class \code{fHMM_model}.}

\item{state_order}{A vector or a matrix which determines the new ordering.
\itemize{
\item If \code{x$data$controls$hierarchy = FALSE}, \code{state_order} must
be a vector of length \code{x$data$controls$states} with integer
values from \code{1} to \code{x$data$controls$states}. If the old
state number \code{x} should be the new state number \code{y}, put
the value \code{x} at the position \code{y} of \code{state_order}.
E.g. for a 2-state HMM, specifying \code{state_order = c(2,1)} swaps
the states.
\item If \code{x$data$controls$hierarchy = TRUE}, \code{state_order} must
be a matrix of dimension \code{x$data$controls$states[1]} x
\code{x$data$controls$states[2] + 1}. The first column orders the
coarse-scale states with the logic as described above. For each row,
the elements from second to last position order the fine-scale states
of the coarse-scale state specified by the first element. E.g. for an
HHMM with 2 coarse-scale and 2 fine-scale states, specifying
\code{state_order = matrix(c(2,1,2,1,1,2),2,3)} swaps the
coarse-scale states and the fine-scale states of coarse-scale state 2.
}}
}
\value{
An object of class \code{fHMM_model}, in which states are reordered.
}
\description{
This function reorders the estimated states, which can be useful for a
comparison to true parameters or the interpretation of states.
}
\examples{
data(dax_model_3t)
reorder_states(dax_model_3t, state_order = 3:1)
}
