% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcwtr_scalogram.R
\name{as.data.frame.fcwtr_scalogram}
\alias{as.data.frame.fcwtr_scalogram}
\title{Coerce the scalogram matrix to a data frame}
\usage{
\method{as.data.frame}{fcwtr_scalogram}(x, ...)
}
\arguments{
\item{x}{An object resulting from \code{\link[=fcwt]{fcwt()}}.}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
A \code{\link[=data.frame]{data.frame()}} object representing the scalogram data with four columns:
\describe{
\item{time_ind}{An integer index uniquely identifying time slices.}
\item{time}{The time difference to the first time slice in physical units.
The time unit is the inverse of the frequency unit chosen by the user
for the \code{sample_freq} argument of \code{\link[=fcwt]{fcwt()}}.}
\item{freq}{The frequency in the same units as the \code{sample_freq} argument
of \code{\link[=fcwt]{fcwt()}}.}
\item{value}{The fCWT result for the particular time-frequency combination.}
}
}
\description{
Internally, the scalogram resulting from \code{\link[=fcwt]{fcwt()}} is represented by
a numeric matrix. This method coerces this matrix into a reasonable
data frame. Note that this conversion has a significant run time cost.
}
\examples{
fcwt(
  sin((1:5000) * 2 * pi * 440 / 44100),
  sample_freq = 44100,
  n_freqs = 10
) |>
as.data.frame() |>
head()

}
