% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_cv.R
\name{mc_cv}
\alias{mc_cv}
\title{Monte Carlo Critical Values}
\usage{
mc_cv(n, nrep = 2000, minw, parallel = FALSE, ncores)
}
\arguments{
\item{n}{A positive integer. The sample size.}

\item{nrep}{A positive integer. The number of Monte Carlo simulations.}

\item{minw}{A positive integer. The minimum window size, which defaults to
\eqn{0.01 + 1.8/\sqrt(T)}{0.01 + 1.8 / \sqrtT}.}

\item{parallel}{Logical. If \code{TRUE} parallel programming is used.}

\item{ncores}{A positive integer, optional. If `parallel' is set to
\code{TRUE}, then the user can specify the number of cores (defaults to
using all cores).}
}
\value{
A list that contains the critical values for ADF, BADF, BSADF and GSADF
t-statistics.
}
\description{
\code{mc_cv} computes Monte Carlo critical values for the recursive unit
root tests.
}
\examples{
\donttest{
# Default minimum window
mc <- mc_cv(n = 100)

# Change the minimum window and the number of simulations
mc <- mc_cv(n = 100, nrep = 2500,  minw = 20)

# Use parallel computing (utilizing all available cores)
mc <- mc_cv(n = 100, parallel = TRUE)
}
}
\seealso{
\code{\link{wb_cv}} for Wild Bootstrapped critical values.
}
