% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R
\name{sim_dgp1}
\alias{sim_dgp1}
\title{Simulation of a single-bubble process}
\usage{
sim_dgp1(n, te = 0.4 * n, tf = 0.15 * n + te, c = 1, alpha = 0.6,
  sigma = 6.79)
}
\arguments{
\item{n}{A strictly positive integer specifying the length of the simulated output series.}

\item{te}{A scalar in (0, tf) specifying the observation in which the bubble originates.}

\item{tf}{A scalar in (te, n) specifying the observation in which the bubble collapses.}

\item{c}{A positive scalar determining the autoregressive coefficient in the explosive regime.}

\item{alpha}{A positive scalar in (0, 1) determining the value of the expansion rate in the autoregressive coefficient.}

\item{sigma}{A positive scalar indicating the standard deviation of the innovations.}
}
\value{
A numeric vector of length n.
}
\description{
The following function generates a time series which switches from a martingale to a mildly explosive
process and then back to a martingale.
}
\details{
The data generating process is described by the following equation:
\deqn{X_t = X_{t-1}1\{t < \tau_e\}+ \delta_T X_{t-1}1\{\tau_e \leq t\leq \tau_f\} +
\left(\sum_{k=\tau_f+1}^t \epsilon_k + X^*_{\tau_f}\right) 1\{t > \tau_f\} + \epsilon_t 1\{t \leq \tau_f\}}{X[t] =
X[t-1] 1{t < te}+ \delta[T] * X[t-1] 1{te \le t \le tf} +
(\sum[k=tf+1]^t \epsilon[k] + X'[tf]) 1{t > tf} + \epsilon[t] 1{t \le tf},}

where the autoregressive coefficient \eqn{\delta_T}{\delta[T]} is given by:

\deqn{\delta_T = 1 + cT^{-a}}{\delta[T] = 1 + c*T^{-a}}

with \eqn{c>0}, \eqn{\alpha \in (0,1)}{\alpha in (0,1)},
\eqn{\epsilon \sim iid(0, \sigma^2)}{\epsilon - iid(0, \sigma^2)} and
\eqn{X_{\tau_f} = X_{\tau_e} + X^*}{X[tf] = X[te] + X'} \eqn{\tau}{t} is the last observation of the sample.
During the pre- and post- bubble periods, \eqn{N_0 = [1, \tau_e)}{N0 = [1, te)}, X is a pure random walk process.
During the bubble expansion period \eqn{B = [\tau_e, \tau_f]}{B = [te,tf]} is a mildly explosive process with expansion rate given by the autoregressive
coefficient \eqn{\delta_T}{\delta[T]}, and continues its martingale path of the subsequent period
\eqn{N_1 = (\tau_f, \tau]}{N1 = (tf, t]}.


For further details the user can refer to Phillips et al., (2015) p. 1054.
}
\examples{
# 100 periods with bubble origination date 40 and termination date 55
sim_dgp1(n = 100)

# 200 periods with bubble origination date 80 and termination date 110
sim_dgp1(n = 200)

# 200 periods with bubble origination date 100 and termination date 150
sim_dgp1(n = 200, te = 100, tf = 150)
}
\references{
Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for Multiple Bubbles:
Historical Episodes of Exuberance and Collapse in the S&P 500. International Economic Review, 5
6(4), 1043-1078.
}
\seealso{
\code{\link{sim_dgp2}}, \code{\link{sim_blan}}, \code{\link{sim_evans}}
}
