% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremeStat-package.R
\docType{data}
\name{weightp}
\alias{weightp}
\title{distribution weights}
\format{named num [1:17]}
\source{
See paper revisions (not yet online at moment of extremeStat update) (\email{berry-b@gmx.de})
}
\description{
Weights for weighted average as in the submission of revisions for the paper
\url{http://www.nat-hazards-earth-syst-sci-discuss.net/nhess-2016-183/}
}
\examples{

data(weightp)
data.frame(weightp)
barplot(weightp, horiz=TRUE, las=1)
stopifnot(   all.equal(sum(weightp), 1)   )

data(annMax) ; data(weightp)
dlf <- distLfit(annMax, weightc=weightp)
dlf$gof
quant <- distLquantile(annMax, weightc=weightp)
quant

}
\keyword{datasets}
