% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{sens_norm}
\alias{sens_norm}
\title{Adjust Normal Distribution Parameters for Sensitivity Analyses}
\usage{
sens_norm(mean, sd, sd_mult = 2)
}
\arguments{
\item{mean}{A numeric vector of the means.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}
}
\value{
A named list of the adjusted distribution's parameters.
}
\description{
Expands (\code{sd_mult > 1}) or reduces (\code{sd_mult < 1}) the standard deviation
of the Normal distribution without changing the mean.
}
\examples{
sens_norm(10, 3, 2)
sens_norm(10, 3, 0.8)
}
\seealso{
Other sens_dist: 
\code{\link{sens_beta}()},
\code{\link{sens_exp}()},
\code{\link{sens_gamma}()},
\code{\link{sens_gamma_pois}()},
\code{\link{sens_gamma_pois_zi}()},
\code{\link{sens_lnorm}()},
\code{\link{sens_neg_binom}()},
\code{\link{sens_pois}()},
\code{\link{sens_skewnorm}()},
\code{\link{sens_student}()}
}
\concept{sens_dist}
