% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract1PSFAERS.R
\name{extract1PSFAERS}
\alias{extract1PSFAERS}
\alias{extract_FAERS_data}
\title{Extract reports with only one drug used from FAERS data}
\usage{
extract_FAERS_data(
  workingdir = NULL,
  usetempdir = FALSE,
  corenum = NULL,
  startfile = NULL,
  endfile = NULL,
  onlydoextract = FALSE,
  occpextract = NULL
)
}
\arguments{
\item{workingdir}{Character vector. The directory containing the decompressed FAERS ASCII folders.}

\item{usetempdir}{Logical. If TRUE, processed files are stored in a temporary directory; otherwise, they are saved in \code{workingdir}.}

\item{corenum}{Numeric. The number of CPU cores to use for parallel processing. Using more cores reduces processing time.}

\item{startfile}{Numeric. The index of the first file to process in the DRUG and related folders.}

\item{endfile}{Numeric. The index of the last file to process in the DRUG and related folders.}

\item{onlydoextract}{Logical. If TRUE, only extracts data without performing additional combination or filtering steps.}

\item{occpextract}{Character vector. Specifies the occupation categories for data extraction. Defaults to \code{c("MD", "HP", "PH", "OT")}.}
}
\value{
A character vector containing the file paths of the processed folders
}
\description{
This function processes the FDA Adverse Event Reporting System (FAERS) data
to extract reports where only a single drug was administered.
}
\details{
This package includes example data files in \code{extdata}:
\itemize{
\item \code{faers_ascii_2015q1_example.zip}: Example dataset 1.
\item \code{faers_ascii_2015q2_example.zip}: Example dataset 2.
\item \code{faers_ascii_2015q3_example.zip}: Example dataset 3.
\item \code{faers_ascii_2015q4_example.zip}: Example dataset 4.
\item Use \code{system.file("extdata",package = "extractFAERS")} to access the folder contain example zip files.
}
}
\examples{
# Example_1 Perform FAERS data preprocessing in one step and
# generate `F_COREDATA_1PS_PROF_STU.RData` in a temporary folder.
# In practice, it is recommended to set `usetempdir = FALSE` and specify `workingdir`
# to prevent the processed results in the temporary folder from being automatically deleted.
extract_FAERS_data(
  workingdir = system.file("extdata", package = "extractFAERS"),
  usetempdir = TRUE,
  corenum = 2,
  startfile = 1,
  endfile = 4,
  onlydoextract = FALSE,
  occpextract = NULL
)

# Example_2 Stepwise FAERS data preprocessing
# Setting `onlydoextract = TRUE` extracts only single-drug cases and organizes file paths.
# The processed file paths are saved in a temporary directory.
extractfaerspath <- extract_FAERS_data(
  workingdir = system.file("extdata", package = "extractFAERS"),
  usetempdir = TRUE,
  corenum = 2,
  startfile = 1,
  endfile = 4,
  onlydoextract = TRUE,
  occpextract = NULL
)
print(extractfaerspath)

# Filter data based on reporter occupation
# By default, only reports from healthcare professionals
# (e.g., physicians, pharmacists) are retained.
faers1psprofdata <- filter_by_occp_FAERS(
  workingdir = extractfaerspath,
  occpextract = NULL,
  savetoRData = TRUE
)

# Standardize time units to days
# This ensures consistency in the dataset and facilitates analysis of adverse reactions
# based on patient age.
time_to_day_FAERS(
workingdir = extractfaerspath,
usexistRData = TRUE,
filteres = NULL
)

}
