/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import org.extratrees.AbstractBinaryTree;
import org.extratrees.Matrix;

public class BinaryTree
extends AbstractBinaryTree {
    public BinaryTree left;
    public BinaryTree right;
    public double value = Double.NEGATIVE_INFINITY;

    public BinaryTree getLeaf(double[] dArray) {
        if (this.left == null) {
            return this;
        }
        if (dArray[this.column] < this.threshold) {
            return this.left.getLeaf(dArray);
        }
        return this.right.getLeaf(dArray);
    }

    public double getValue(double[] dArray) {
        if (this.left == null) {
            return this.value;
        }
        if (dArray[this.column] < this.threshold) {
            return this.left.getValue(dArray);
        }
        return this.right.getValue(dArray);
    }

    public double getValueMT(double[] dArray, int n) {
        if (this.left == null) {
            return this.value;
        }
        if (this.column < 0) {
            if (this.left.tasks.contains(n)) {
                return this.left.getValueMT(dArray, n);
            }
            return this.right.getValueMT(dArray, n);
        }
        if (dArray[this.column] < this.threshold) {
            return this.left.getValueMT(dArray, n);
        }
        return this.right.getValueMT(dArray, n);
    }

    public double[] getValues(Matrix matrix) {
        double[] dArray = new double[matrix.nrows];
        double[] dArray2 = new double[matrix.ncols];
        for (int i = 0; i < matrix.nrows; ++i) {
            for (int j = 0; j < matrix.ncols; ++j) {
                dArray2[j] = matrix.get(i, j);
            }
            dArray[i] = this.getValue(dArray2);
        }
        return dArray;
    }

    public double getValue(double[] dArray, int n) {
        if (this.nSuccessors < n || this.left == null) {
            return this.value;
        }
        if (dArray[this.column] < this.threshold) {
            return this.left.getValue(dArray, n);
        }
        return this.right.getValue(dArray, n);
    }

    public double[] getValues(Matrix matrix, int n) {
        double[] dArray = new double[matrix.nrows];
        double[] dArray2 = new double[matrix.ncols];
        for (int i = 0; i < matrix.nrows; ++i) {
            for (int j = 0; j < matrix.ncols; ++j) {
                dArray2[j] = matrix.get(i, j);
            }
            dArray[i] = this.getValue(dArray2, n);
        }
        return dArray;
    }

    public int[] countColumns(int n) {
        int[] nArray = new int[n];
        this.countColumns(nArray);
        return nArray;
    }

    public void countColumns(int[] nArray) {
        if (this.left == null) {
            return;
        }
        int n = this.column;
        nArray[n] = nArray[n] + 1;
        this.left.countColumns(nArray);
        this.right.countColumns(nArray);
    }
}

