% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_metrics.R
\name{add_metrics}
\alias{add_metrics}
\title{Add Metrics}
\usage{
add_metrics(
  expstudy,
  ...,
  .metrics = c("act2expec", "act2expos", "expec2expos"),
  .metric_nms = list(act2expec = "ACTUAL_TO_EXPECTED", act2expos = "ACTUAL_TO_EXPOSED",
    expec2expos = "EXPECTED_TO_EXPOSED")
)
}
\arguments{
\item{expstudy}{an \code{\link[=expstudy]{expstudy()}}}

\item{...}{additional metrics to add. Can be name-value pairs or simply the
metric's formula.}

\item{.metrics}{default methods to add; if omitted, all metrics listed will
be added}

\item{.metric_nms}{pairlist of .metric names; can be character vector for
\code{expstudy} object with multiple columns per \code{.metrics} argument}
}
\value{
An \code{expstudy} object with added metrics. See \code{\link[=expstudy]{expstudy()}} for
additional detail on \code{expstudy} objects.
}
\description{
Add commonly used metrics to an \code{\link[=expstudy]{expstudy()}}. This typically would be after
grouping by variables of interest, but doesn't have to be. The following
metrics are available by default and use the \code{expstudy}'s metric variables
(\code{actuals}, \code{expecteds}, and\code{exposures}).
\itemize{
\item \code{'act2expec'}: actuals to expecteds (i.e., A/E ratios)
\item \code{'act2expos'}: actuals to exposures (i.e., average actually observed)
\item \code{'expec2expos'}: expecteds to exposures (i.e., average expected)
}

You can also create custom metrics to add by providing (optionally named)
metric formulae.
}
\examples{
  es <- expstudy(
    data = mortexp,
    actuals = ACTUAL_DEATHS,
    expecteds = EXPECTED_DEATHS,
    exposures =  EXPOSURE,
    variances = VARIANCE_DEATHS
  )

  # If no arguments are provided, all default metrics will be generated. This
  # mostly makes sense for already aggregated expstudy objects, but can be used
  # with unaggregated objects as well.
   es \%>\%
     aggregate(ATTAINED_AGE) \%>\%
     add_metrics

   es \%>\%
     aggregate(
       UNDERWRITING_CLASS,
       GENDER,
       SMOKING_STATUS
     ) \%>\%
     add_metrics

}
