% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.3-plGridMulti.R
\name{plGridMulti}
\alias{plGridMulti}
\title{Perform High-Throughput Classification}
\usage{
plGridMulti(array.train, array.valid = NULL, ctrlFS, top, how,
  aucSkip = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{array.train}{Specifies the \code{ExprsMulti} object to use as training set.}

\item{array.valid}{Specifies the \code{ExprsMulti} object to use as validation set.}

\item{ctrlFS}{A list of arguments handled by \code{\link{ctrlFeatureSelect}}.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. Note that providing a numeric vector
for the \code{top} argument will have \code{plGrid} search across multiple
top features. However, by providing a list of numeric vectors as the \code{top}
argument, the user can force the default handling of numeric vectors.}

\item{how}{A character string. Specifies the \code{\link{build}} method to iterate.}

\item{aucSkip}{A logical scalar. Argument passed to \code{\link{calcStats}}.}

\item{verbose}{A logical scalar. Argument passed to \code{\link{exprso-predict}}.}

\item{...}{Arguments passed to the \code{how} method. Unlike the \code{build} method,
\code{plGrid} allows multiple parameters for each argument, supplied as a vector.
See Details.}
}
\value{
An \code{\link{ExprsPipeline-class}} object.
}
\description{
Trains and deploys multiple classifiers across a vast parameter search space.
}
\details{
Unlike \code{plGrid}, the \code{plGridMulti} function accepts a \code{ctrlFS}
 argument, allowing for 1-vs-all classification with implicit feature selection.
 1-vs-all classification, this function divides the data into 1-vs-all bins,
 performs a 1-vs-all feature selection for each bin, and then performs a 1-vs-all
 classification for that same bin. As such, each \code{ExprsMachine} within the
 \code{ExprsModule} will have its own unique feature selection history.

Take note, that \code{plGridMulti} does not have built-in \code{plCV} support.
 To use \code{plGridMulti} with cross-validation, use \code{plNested}.
}
\seealso{
\code{\link{fs}}\cr
\code{\link{build}}\cr
\code{\link{doMulti}}\cr
\code{\link{exprso-predict}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}

