% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.1-split.R
\docType{methods}
\name{split}
\alias{split}
\alias{splitSample}
\alias{splitSample,ExprsArray-method}
\alias{splitStratify}
\alias{splitStratify,ExprsArray-method}
\title{split \code{ExprsArray} objects}
\usage{
splitSample(object, percent.include, ...)

splitStratify(object, percent.include, colBy = NULL, bin = rep(FALSE,
  length(colBy)), breaks = rep(list(NA), length(colBy)), ...)

\S4method{splitSample}{ExprsArray}(object, percent.include, ...)

\S4method{splitStratify}{ExprsArray}(object, percent.include, colBy = NULL,
  bin = rep(FALSE, length(colBy)), breaks = rep(list(NA), length(colBy)),
  ...)
}
\arguments{
\item{object}{Specifies the \code{ExprsArray} object to split.}

\item{percent.include}{Specifies the percent of the total number
of subjects to include in the training set.}

\item{...}{For \code{splitSample}: additional arguments passed
along to \code{\link{sample}}. For \code{splitStratify}: additional
arguments passed along to \code{\link{cut}}.}

\item{colBy}{Specifies a vector of column names by which to stratify in
addition to class labels annotation. If \code{colBy = NULL}, random
sampling will occur across the class label annotation only.
For \code{splitStratify} only.}

\item{bin}{A logical vector indicating whether to bin the respective
\code{colBy} column using \code{cut} (e.g., \code{bin = c(FALSE, TRUE)}).
For \code{splitStratify} only.}

\item{breaks}{A list. Each element of the list should correspond to a
\code{breaks} argment passed to \code{cut} for the respective
\code{colBy} column. Set an element to \code{NA} when not binning
that \code{colBy}. For \code{splitStratify} only.}
}
\value{
Returns a list of two \code{ExprsArray} objects.
}
\description{
A collection of functions to build the training and validation sets.
}
\details{
\code{splitSample} builds a training and validation set by randomly sampling
 the subjects found within the \code{ExprsArray} object. Note that this method
 is not truly random. Instead, \code{splitSample} iterates through the random sampling
 process until it settles on a solution such that both the training and validation set
 contain at least one subject for each class label. If this method finds no solution
 after 10 iterations, the function will post an error. Set \code{percent.include = 100}
 to skip random sampling and return a \code{NULL} validation set. Additional arguments
 (e.g., \code{replace = TRUE}) passed along to \code{\link{sample}}. This method works well
 for all (i.e., binary and multi-class) \code{ExprsArray} objects.

\code{splitStratify} builds a training and validation set through a stratified
 random sampling process. This function utilizes the \code{strata} function from the
 sampling package as well as the \code{cut} function from the base package. The latter
 function provides a means by which to bin continuous data prior to stratified random
 sampling. We refer the user to the parameter descriptions to learn the specifics of
 how to apply binning, although the user might find it easier to instead bin
 annotations beforehand. When applied to an \code{ExprsMulti} object, this function
 stratifies subjects across all classes found in that dataset.
}
\seealso{
\code{\link{ExprsArray-class}}
}

