% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powoFam.R
\name{powoFam}
\alias{powoFam}
\title{Extract species number of any plant family from POWO}
\usage{
powoFam(family, verbose = TRUE, save = FALSE, dir, filename)
}
\arguments{
\item{family}{Either one family name or a vector of multiple families that
is present in POWO.}

\item{verbose}{Logical, if \code{FALSE}, the search results will not be
printed in the console in full.}

\item{save}{Logical, if \code{FALSE}, the search results will not be saved on
disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_powoFam} and the searched results
will be saved within a subfolder named by the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
Table in .csv format.
}
\description{
Produces a CSV file listing the number of species within the
target botanical families of flowering plants available at
\href{https://powo.science.kew.org/}{Plants of the World Online (POWO)}.
}
\examples{
\donttest{
library(expowo)

powoFam(family = "Lecythidaceae",
        verbose = TRUE,
        save = FALSE,
        dir = "results_powoFam/",
        filename = "Lecythidaceae_spp_number")
}

}
\seealso{
\code{\link{megaGen}}

\code{\link{topGen}}

\code{\link{powoGenera}}

\code{\link{powoSpecies}}

\code{\link{powoMap}}

\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
