% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatial}
\alias{spatial}
\title{Distribute the sample on the plate}
\usage{
spatial(
  index,
  pheno,
  omit = NULL,
  remove_positions = NULL,
  rows = LETTERS[1:5],
  columns = 1:10,
  iterations = 500
)
}
\arguments{
\item{index}{A list with the samples on each subgroup, as provided from
\code{\link[=design]{design()}} or \code{\link[=replicates]{replicates()}}.}

\item{pheno}{Data.frame with the sample information.}

\item{omit}{Name of the columns of the \code{pheno} that will be omitted.}

\item{remove_positions}{Character, name of positions to be avoided in the grid.}

\item{rows}{Character, name of the rows to be used.}

\item{columns}{Character, name of the rows to be used.}

\item{iterations}{Numeric value of iterations that will be performed.}
}
\value{
The indices of which samples go with which batch.
}
\description{
This function assumes that to process the batch the samples are distributed in
a plate with a grid scheme.
}
\examples{
data(survey, package = "MASS")
index <- design(survey[, c("Sex", "Smoke", "Age")], size_subset = 50,
                iterations = 10)
index2 <- spatial(index, survey[, c("Sex", "Smoke", "Age")], iterations = 10)
head(index2)
}
