% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exoplanets.R
\name{exoplanets}
\alias{exoplanets}
\title{Retrieve Data from NASAs Exoplanet Archive}
\source{
\url{https://exoplanetarchive.ipac.caltech.edu/}
}
\usage{
exoplanets(table, columns = NULL, format = "csv", progress = TRUE)
}
\arguments{
\item{table}{A table name, see `tableinfo`}

\item{columns}{A vector of valid column names, by default will return all default columns, see `tableinfo`}

\item{format}{Desired format, either csv, tsv, or json}

\item{progress}{Whether or not to display the progress of the request}
}
\value{
A \code{data.frame} if \code{format="csv"} or \code{format="tsv"}.
A \code{list} if \code{format="json"}.
}
\description{
A simple interface for accessing exoplanet data. At the bare minimum, a table
name is required. Tables names are documented in the `tableinfo` dataset.
}
\details{
At one time, this package used the Exoplanet Archive Application Programming
Interface (API). Since then, a handful of tables have been transitioned to
the Table Access Protocol (TAP) service. More tables will be transitioned to
TAP and as such, this package only supports queries from TAP. For more
information, you can read
\url{https://exoplanetarchive.ipac.caltech.edu/docs/exonews_archive.html#29April2021.}
}
\examples{
if (interactive()) {
  # request all default columns from the `ps` table
  exoplanets("ps")

  # request the planet name and discovery method from the `ps` table
  exoplanets("ps", c("pl_name", "discoverymethod"))

  # request in json format (returns list)
  exoplanets("ps", c("pl_name", "discoverymethod"), format = "json")

  # hide progress information
  exoplanets("k2names", progress = FALSE)
}

}
\seealso{
tableinfo
}
