\name{exams2tcexam}
\alias{exams2tcexam}

\title{Generation of Exams in TCExam Format}

\description{
  Interface for generating exams in TCExam format.
}

\usage{
  exams2tcexam(file, n = 1L, nsamp = NULL, dir = ".",
    name = NULL, quiet = TRUE, edir = NULL, tdir = NULL, sdir = NULL, verbose = FALSE,
    resolution = 100, width = 4, height = 4, svg = FALSE, encoding = "", points = NULL,
    modulename = name, subjectname = name, subjectdescription = NULL, timer = 0,
    fullscreen = FALSE, inlineanswers = FALSE, autonext = FALSE, shuffle = FALSE,
    lang = "en", date = Sys.time(), zip = FALSE, converter = NULL, \dots)
}

\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{nsamp, quiet, edir, tdir, sdir, verbose}{arguments passed to \code{\link[exams]{xexams}}.}
  \item{dir}{character specifying the output directory path. The default is
    the current working directory.}
  \item{name}{character. A name prefix for resulting XML file.}
  \item{resolution, width, height, svg, encoding}{arguments passed to \code{\link[exams]{xweave}}.}
  \item{points}{numeric. Number of points for the questions.}
  \item{modulename}{character. Module name.}
  \item{subjectname}{character. Subject name.}
  \item{subjectdescription}{character. Subject description.}
  \item{timer}{numeric. Number of seconds for each question.}
  \item{fullscreen}{logical. Should the question be shown in full-screen mode?}
  \item{inlineanswers}{logical. Should the question list be presented inline?}
  \item{autonext}{logical. Automatically advance to the next item?}
  \item{shuffle}{logical. Should the question list of schoice/mchoice answers be
    shuffled (or kept fixed)?}
  \item{lang}{character. Two-letter indicator of the language.}
  \item{date}{character or \code{"Date"} object specifying the date of the exam.}
  \item{zip}{logical. Should the resulting XML file be zipped?}
  \item{converter, \dots}{arguments passed on to \code{make_exercise_transform_html}.
    The default for \code{converter} is set to \code{"ttm"} unless there are Rmd
    exercises in \code{file} where \code{"pandoc"} is used.}
}

\details{
  \code{exams2tcexam} generates XML exams that can be imported into the TCExam software
  of Asuni (2012). Currently, the subset of HTML(-like) commands that is supported in
  TCExam is rather limited, e.g., tables and figures cannot be directly included.
}

\references{
Asuni (2012). \emph{TCExam: Computer-Based Assessment Software}.
  \url{http://tcexam.org/}.
}

\value{
  A list of exams as generated by \code{\link[exams]{xexams}} is
  returned invisibly.
}

\examples{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

\dontrun{
## exams2tcexam creates a single XML file
exams2tcexam("tstat2", n = 2)
}
}

\keyword{utilities}
