% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toHTML.R
\name{toHTML.html_matrix}
\alias{toHTML.html_matrix}
\alias{toLatex}
\alias{toHTMLorLatex}
\alias{toLatex.html_matrix}
\title{HTML and LaTeX Matrix Representations}
\usage{
\method{toHTML}{html_matrix}(x, browser = FALSE, ...)

\method{toLatex}{html_matrix}(object, ...)

toHTMLorLatex(x, ...)
}
\arguments{
\item{x, object}{html_matrix object}

\item{browser}{logical: show the HTML in a browser (default: \code{FALSE})}

\item{...}{further parameters to \code{\link[utils:browseURL]{utils::browseURL()}}}
}
\value{
character
}
\description{
\itemize{
\item \code{toHTML} returns an HTML representation of a matrix and, optionally, shows the result in the browser.
If you decide to view the result in a browser then the HTML will be written to a temporary file and
\code{\link[utils:browseURL]{utils::browseURL()}} will be called
\item \code{toLatex} returns a LaTeX representation of a matrix, but supports just a small subset of style options
\item \code{toHTMLorLatex} returns an HTML or LaTeX representation of a matrix, depending if \code{exams2pdf} is in the call list or not
}
}
\examples{
library("tools")
m    <- matrix(1:12, ncol=4)
hm   <- html_matrix(m)
if (interactive()) html <- toHTML(hm, browser=TRUE)
toHTML(hm)
toLatex(hm)
}
