% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07B_InfiniteRelationalModel.R
\name{IRM}
\alias{IRM}
\title{Infinite Relational Model}
\usage{
IRM(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  gamma_c = 1,
  gamma_f = 1,
  max_iter = 100,
  stable_limit = 5,
  minSize = 20,
  EM_limit = 20,
  seed = 123,
  verbose = TRUE
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{gamma_c}{\eqn{\gamma_C} is the hyperparameter of the CRP and represents the
attractiveness of a new Class. As \eqn{\gamma_C} increases, the student is more likely
to be seated at a vacant class. The default is 1.}

\item{gamma_f}{\eqn{\gamma_F} is the hyperparameter of the CRP and represents the
attractiveness of a new Field. The greater this value it more likely to be classified
in the new field. The default is 1.}

\item{max_iter}{A maximum iteration number of IRM process. The default is 100.}

\item{stable_limit}{The IRM process exits the loop when the FRM stabilizes and no longer
changes significantly. This option sets the maximum number of stable iterations,
with a default of 5.}

\item{minSize}{A value used for readjusting the number of classes.If the size of each
class is less than \code{minSize}, the number of classes will be reduced. Note that this
under limit of size is not used for either all correct or all incorrect class.}

\item{EM_limit}{After IRM process, resizing the number of classes process will starts.
This process using EM algorithm,\code{EM_limit} is the maximum number of iteration with
default of 20.}

\item{seed}{seed value for random numbers.}

\item{verbose}{verbose output Flag. default is TRUE}
}
\value{
\describe{
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{Nclass}{Optimal number of classes.}
\item{Nfield}{Optimal number of fields.}
\item{BRM}{Bicluster Reference Matrix}
\item{FRP}{Field Reference Profile}
\item{FRPIndex}{Index of FFP includes the item location parameters B and Beta,
the slope parameters A and Alpha, and the monotonicity indices C and Gamma.}
\item{TRP}{Test Reference Profile}
\item{FMP}{Field Membership Profile}
\item{Students}{Rank Membership Profile matrix.The s-th row vector of \eqn{\hat{M}_R}, \eqn{\hat{m}_R}, is the
rank membership profile of Student s, namely the posterior probability distribution representing the student's
belonging to the respective latent classes. It also includes the rank with the maximum estimated membership probability,
as well as the rank-up odds and rank-down odds.}
\item{LRD}{Latent Rank Distribution. see also \link{plot.exametrika}}
\item{LFD}{Latent Field Distribution. see also \link{plot.exametrika}}
\item{RMD}{Rank Membership Distribution.}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
}
}
\description{
The purpose of this method is to find
the optimal number of classes C, and optimal number of
fields F. It can be found in a single run of the analysis, but
it takes a long computation time when the sample size S is large.
In addition, this method incorporates the Chinese restaurant process
and Gibbs sampling. In detail, See Section 7.8 in Shojima(2022).
}
\examples{
\donttest{
# Fit an Infinite Relational Model (IRM) to determine optimal number of classes and fields
# gamma_c and gamma_f are concentration parameters for the Chinese Restaurant Process
result.IRM <- IRM(J35S515, gamma_c = 1, gamma_f = 1, verbose = TRUE)

# Display the Bicluster Reference Matrix (BRM) as a heatmap
# Shows the discovered clustering structure of items and students
plot(result.IRM, type = "Array")

# Plot Field Reference Profiles (FRP) in a 3-column grid
# Shows the probability patterns for each automatically determined field
plot(result.IRM, type = "FRP", nc = 3)

# Plot Test Reference Profile (TRP)
# Shows the overall response pattern across all fields
plot(result.IRM, type = "TRP")
}

}
