% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmodel.R
\name{prepare_model}
\alias{prepare_model}
\title{Prepare the models from the \code{evmodel} object ready for the simulation}
\usage{
prepare_model(ev_models, sessions_day, user_profiles)
}
\arguments{
\item{ev_models}{tibble with models from an \code{evmodel} object}

\item{sessions_day}{tibble with variables \code{time_cycle} (names corresponding to \code{evmodel$models$time_cycle}) and \code{n_sessions} (number of daily sessions per day for each time-cycle model)}

\item{user_profiles}{tibble with variables \code{time_cycle}, \code{user_profile}, \code{ratio} and optionally \code{power}.
The powers must be in kW and the ratios between 0 and 1.
The user profiles with a value of \code{power} will be simulated with this specific charging power.
If \code{power} is \code{NA} then it is simulated according to the ratios of parameter \code{charging_powers} in function. \code{simulate_sessions}.}
}
\value{
tibble
}
\description{
The ratios and default charging power for every user profile,
and the sessions per day for every time cycle are included.
}
\keyword{internal}
