% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAsimilarity.R
\name{PCAsimilarity}
\alias{PCAsimilarity}
\alias{PCAsimilarity.default}
\alias{PCAsimilarity.list}
\alias{PCAsimilarity.mcmc_sample}
\title{Compare matrices using PCA similarity factor}
\usage{
PCAsimilarity(cov.x, cov.y, ...)

\method{PCAsimilarity}{default}(cov.x, cov.y, ret.dim = NULL, ...)

\method{PCAsimilarity}{list}(cov.x, cov.y = NULL, ..., repeat.vector = NULL,
  parallel = FALSE)

\method{PCAsimilarity}{mcmc_sample}(cov.x, cov.y, ..., parallel = FALSE)
}
\arguments{
\item{cov.x}{Single covariance matrix ou list of covariance matrices.
If cov.x is a single matrix, it is compared to cov.y.
If cov.x is a list and no cov.y is suplied, all matrices
are compared to each other.
If cov.x is a list and cov.y is suplied, all matrices in cov.x are compared to cov.y.}

\item{cov.y}{First argument is compared to cov.y.}

\item{...}{aditional arguments passed to other methods}

\item{ret.dim}{number of retained dimensions in the comparison. Defaults to all.}

\item{repeat.vector}{Vector of repeatabilities for correlation correction.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
Ratio of projected variance to total variance
}
\description{
Compare matrices using PCA similarity factor
}
\examples{
c1 <- RandomMatrix(10)
c2 <- RandomMatrix(10)
PCAsimilarity(c1, c2)

m.list <- RandomMatrix(10, 3)
PCAsimilarity(m.list)

PCAsimilarity(m.list, c1)
}
\references{
Singhal, A. and Seborg, D. E. (2005), Clustering multivariate time-series data. J. Chemometrics, 19: 427-438. doi: 10.1002/cem.945
}
\seealso{
\code{\link{KrzProjection}},\code{\link{KrzCor}},\code{\link{RandomSkewers}},\code{\link{MantelCor}}
}
\author{
Edgar Zanella Alvarenga
}
\keyword{Krzanowski}
\keyword{PCA}
\keyword{matrixcomparison}
\keyword{matrixcorrelation}
