% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MonteCarloStat.R
\name{MonteCarloR2}
\alias{MonteCarloR2}
\title{R2 confidence intervals by parametric sampling}
\usage{
MonteCarloR2(cov.matrix, sample.size, iterations = 1000, parallel = FALSE)
}
\arguments{
\item{cov.matrix}{Covariance matrix.}

\item{sample.size}{Size of the random populations}

\item{iterations}{Number of random populations}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns a vector with the R2 for all populations
}
\description{
Using a multivariate normal model, random populations are generated
using the suplied covariance matrix. R2 is calculated on all the
random population, provinding a distribution based on the original matrix.
}
\details{
Since this function uses multivariate normal model to generate populations, only covariance matrices should be used.
}
\examples{
r2.dist <- MonteCarloR2(RandomMatrix(10, 1, 1, 10), 30)
quantile(r2.dist)
}
\author{
Diogo Melo Guilherme Garcia
}
\seealso{
\code{\link{BootstrapRep}}, \code{\link{AlphaRep}}
}
\keyword{montecarlo}
\keyword{parametricsampling}
\keyword{repeatability}

