% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.all.univariate.R
\name{fit.all.univariate}
\alias{fit.all.univariate}
\title{Fit all univariate models to an evolutionary sequence (time-series).}
\usage{
fit.all.univariate(y, pool = TRUE)
}
\arguments{
\item{y}{an univariate paleoTS object.}

\item{pool}{indicating whether to pool variances across samples}
}
\value{
The function returns a list of all investigated models and their highest log-likelihood (and their corresponding AICc and AICc weight).
}
\description{
Wrapper function to find maximum likelihood solutions for all univariate models (excluding models with mode shifts) to an evolutionary sequence (time-series).
}
\examples{
## ##Generate a paleoTS object.
x <- paleoTS::sim.GRW(30)

## Fit univariate models to the data.
fit.all.univariate(x, pool = TRUE)

}
\references{
Hunt, G. 2006. Fitting and comparing models of phyletic evolution: random walks and beyond. \emph{Paleobiology} 32:578–601

Hunt, G., Bell, M. A. & Travis, M. P. Evolution towards a new adaptive optimum: Phenotypic evolution in a fossil stickleback lineage. \emph{Evolution} 62:700–710 (2008)
}
\author{
Kjetil Lysne Voje
}
