% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flognormgpd.r
\name{flognormgpd}
\alias{flognormgpd}
\alias{llognormgpd}
\alias{nllognormgpd}
\alias{nlulognormgpd}
\alias{proflulognormgpd}
\title{MLE Fitting of log-normal Bulk and GPD Tail Extreme Value Mixture Model}
\usage{
flognormgpd(x, phiu = TRUE, useq = NULL, fixedu = FALSE, pvector = NULL,
  std.err = TRUE, method = "BFGS", control = list(maxit = 10000),
  finitelik = TRUE, ...)

llognormgpd(x, lnmean = 0, lnsd = 1, u = qlnorm(0.9, lnmean, lnsd),
  sigmau = sqrt(lnmean) * lnsd, xi = 0, phiu = TRUE, log = TRUE)

nllognormgpd(pvector, x, phiu = TRUE, finitelik = FALSE)

proflulognormgpd(u, pvector, x, phiu = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = TRUE, ...)

nlulognormgpd(pvector, u, x, phiu = TRUE, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{phiu}{probability of being above threshold \eqn{(0, 1)} or logical, see Details in
help for \code{\link[evmix:fnormgpd]{fnormgpd}}}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{lnmean}{scalar mean on log scale}

\item{lnsd}{scalar standard deviation on log scale (positive)}

\item{u}{scalar threshold value}

\item{sigmau}{scalar scale parameter (positive)}

\item{xi}{scalar shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
Log-likelihood is given by \code{\link[evmix:flognormgpd]{llognormgpd}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:flognormgpd]{nllognormgpd}}
  and \code{\link[evmix:flognormgpd]{nlulognormgpd}}. Profile likelihood for single
  threshold given by \code{\link[evmix:flognormgpd]{proflulognormgpd}}. Fitting function
  \code{\link[evmix:flognormgpd]{flognormgpd}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedu}:    \tab fixed threshold, logical\cr
 \code{useq}:      \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:  \tab profile negative log-likelihood at each threshold in useq\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:      \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{lnmean}:    \tab MLE of log-normal mean\cr
 \code{lnsd}:      \tab MLE of log-normal shape\cr
 \code{u}:         \tab threshold (fixed or MLE)\cr
 \code{sigmau}:    \tab MLE of GPD scale\cr
 \code{xi}:        \tab MLE of GPD shape\cr
 \code{phiu}:      \tab MLE of tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiu}:   \tab standard error of MLE of tail fraction\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value
mixture model with log-normal for bulk distribution upto the threshold and conditional
GPD above threshold. With options for profile likelihood estimation for threshold and
fixed threshold approach.
}
\details{
The extreme value mixture model with log-normal bulk and GPD tail is
fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details, type \code{help fnormgpd}.
Only the different features are outlined below for brevity.

The full parameter vector is
(\code{lnmean}, \code{lnsd}, \code{u}, \code{sigmau}, \code{xi}) if threshold is also estimated and
(\code{lnmean}, \code{lnsd}, \code{sigmau}, \code{xi}) for profile likelihood or fixed threshold approach.

Non-positive data are ignored.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of log-normal parameters assuming entire population is log-normal; and
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters above threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 1))

x = rlnorm(1000)
xx = seq(-0.1, 10, 0.01)
y = dlnorm(xx)

# Bulk model based tail fraction
fit = flognormgpd(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-0.1, 10), ylim = c(0, 0.8))
lines(xx, y)
with(fit, lines(xx, dlognormgpd(xx, lnmean, lnsd, u, sigmau, xi), col="red"))
abline(v = fit$u, col = "red")

# Parameterised tail fraction
fit2 = flognormgpd(x, phiu = FALSE)
with(fit2, lines(xx, dlognormgpd(xx, lnmean, lnsd, u, sigmau, xi, phiu), col="blue"))
abline(v = fit2$u, col = "blue")
legend("topright", c("True Density","Bulk Tail Fraction","Parameterised Tail Fraction"),
  col=c("black", "red", "blue"), lty = 1)

# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = flognormgpd(x, useq = seq(1, 5, length = 20))
fitfix = flognormgpd(x, useq = seq(1, 5, length = 20), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-0.1, 10), ylim = c(0, 0.8))
lines(xx, y)
with(fit, lines(xx, dlognormgpd(xx, lnmean, lnsd, u, sigmau, xi), col="red"))
abline(v = fit$u, col = "red")
with(fitu, lines(xx, dlognormgpd(xx, lnmean, lnsd, u, sigmau, xi), col="purple"))
abline(v = fitu$u, col = "purple")
with(fitfix, lines(xx, dlognormgpd(xx, lnmean, lnsd, u, sigmau, xi), col="darkgreen"))
abline(v = fitfix$u, col = "darkgreen")
legend("topright", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Lognormal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Solari, S. and Losada, M.A. (2004). A unified statistical model for
hydrological variables including the selection of threshold for the peak over
threshold method. Water Resources Research. 48, W10541.
}
\seealso{
\code{\link[stats:Lognormal]{dlnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}

Other lognormgpd lognormgpdcon flognormgpd flognormgpdcon normgpd fnormgpd: \code{\link{flognormgpdcon}},
  \code{\link{flognormgpdcon}},
  \code{\link{flognormgpdcon}},
  \code{\link{flognormgpdcon}},
  \code{\link{flognormgpdcon}},
  \code{\link{llognormgpdcon}},
  \code{\link{llognormgpdcon}},
  \code{\link{llognormgpdcon}},
  \code{\link{llognormgpdcon}},
  \code{\link{llognormgpdcon}},
  \code{\link{nllognormgpdcon}},
  \code{\link{nllognormgpdcon}},
  \code{\link{nllognormgpdcon}},
  \code{\link{nllognormgpdcon}},
  \code{\link{nllognormgpdcon}},
  \code{\link{nlulognormgpdcon}},
  \code{\link{nlulognormgpdcon}},
  \code{\link{nlulognormgpdcon}},
  \code{\link{nlulognormgpdcon}},
  \code{\link{nlulognormgpdcon}},
  \code{\link{proflulognormgpdcon}},
  \code{\link{proflulognormgpdcon}},
  \code{\link{proflulognormgpdcon}},
  \code{\link{proflulognormgpdcon}},
  \code{\link{proflulognormgpdcon}}
}

