% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fuzzy_credpart.R
\name{create_fuzzy_credpart}
\alias{create_fuzzy_credpart}
\title{Creation of a "credpart" object from a from a fuzzy or possibilistic partition matrix}
\usage{
create_fuzzy_credpart(U)
}
\arguments{
\item{U}{A fuzzy or possibilistic partition matrix of size n*c, wheer c is the nmber of clusters.}
}
\value{
An object of class "credpart".
}
\description{
\code{create_fuzzy_credpart} creates a "credpart" object from a fuzzy or possibilistic partition matrix.
}
\examples{
\dontrun{
library(fclust)
U<-FKM(fourclass[,1:2],4)$U
clus<-create_fuzzy_credpart(U)
summary(clus)
}
}
\references{
T. Denoeux, S. Li and S. Sriboonchitta. Evaluating and Comparing Soft Partitions: an 
 Approach Based on Dempster-Shafer Theory. IEEE Transactions on Fuzzy Systems, 
 26(3):1231-1244, 2018.
}
\seealso{
\code{\link{extractMass}},\code{\link{create_hard_credpart}}
}
