#' Summary of a credal partition
#'
#' \code{summary.credpart} is the \code{summary} method for \code{"credpart"} objects.
#'
#' This function extracts basic information from \code{"credpart"} objects, such as created by
#' \code{\link{ecm}}, \code{\link{recm}}, \code{\link{cecm}}, \code{\link{EkNNclus}}or
#'  \code{\link{kevclus}}.
#'
#' @param object An object of class \code{"credpart"}, encoding a credal partition.
#' @param ... Additional arguments (not used).
#'
#' @return Prints basic information on the credal partition.
#'
#' @import R.utils
#' @export
#'
#' @seealso \code{\link{extractMass}}, \code{\link{plot.credpart}}, \code{\link{ecm}},
#' \code{\link{recm}}, \code{\link{cecm}}, \code{\link{EkNNclus}}, \code{\link{kevclus}}.
#'
#' @references
#' T. Denoeux and O. Kanjanatarakul. Beyond Fuzzy, Possibilistic and Rough: An
#' Investigation of Belief Functions in Clustering. 8th International conference on soft
#' methods in probability and statistics, Rome, 12-14 September, 2016.
#'
#' M.-H. Masson and T. Denoeux. ECM: An evidential version of the fuzzy c-means algorithm.
#' Pattern Recognition, Vol. 41, Issue 4, pages 1384--1397, 2008.
#'
#'T. Denoeux, S. Sriboonchitta and O. Kanjanatarakul. Evidential clustering of large
#'dissimilarity data. Knowledge-Based Systems, vol. 106, pages 179-195, 2016.
#'
#' Available from \url{https://www.hds.utc.fr/~tdenoeux}.
#' @examples
#' ## Example with Four-class data
#' data("fourclass")
#' x<-fourclass[,1:2]
#' y<-fourclass[,3]
#' c=4
#' ## Running k-EVCLUS with singletons
#' clus<-kevclus(x=x,k=100,c=c,type='simple')
#' summary(clus)
summary.credpart<-function(object,...){
  clus<-object
  c<-ncol(clus$F)
  n<-nrow(clus$mass)
  printf("------ Credal partition ------\n")
  printf("%i classes,",c)
  printf("%i objects\n",n)
  printf("Generated by %s\n",clus$method)
  printf("Focal sets:\n")
  print(clus$F)
  printf("Value of the criterion=%.2f\n",clus$crit)
  printf("Nonspecificity=%.2f\n",clus$N)
  if(!is.null(clus$g)){
    printf("Prototypes:\n")
    print(clus$g)
  }
  printf("Number of outliers=%.2f\n",length(clus$outlier))
}
