% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gpdPbScore.R
\name{gpdPbScore}
\alias{gpdPbScore}
\title{GPD Parametric Bootstrap Score Test}
\usage{
gpdPbScore(data, B, information = c("expected", "observed"),
  allowParallel = FALSE, numCores = 1)
}
\arguments{
\item{data}{Data should be in vector form.}

\item{B}{Number of bootstrap replicates.}

\item{information}{To use expected (default) or observed information in the test.}

\item{allowParallel}{Should the bootstrap procedure be run in parallel or not. Defaults to false.}

\item{numCores}{If allowParallel is true, specify the number of cores to use.}
}
\value{
statistic Test statistic.

p.value P-value for the test.

theta Estimated value of theta for the initial data.
}
\description{
Parametric bootstrap score test procedure to assess goodness-of-fit to the Generalized Pareto distribution.
}
\examples{
## Generate some data from GPD
x <- rgpd(200, loc = 0, scale = 1, shape = 0.2)
gpdPbScore(x, 100)
}

