% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gpdAd.R
\name{gpdAd}
\alias{gpdAd}
\title{Generalized Pareto Distribution Anderson-Darling Test}
\usage{
gpdAd(data, bootstrap = FALSE, B = NULL, allowParallel = FALSE,
  numCores = 1)
}
\arguments{
\item{data}{Data should be in vector form, assumed to be from the GPD.}

\item{bootstrap}{Should bootstrap be used to obtain p-values for the test? By default, a table of critical values is used via interpolation. See details.}

\item{B}{Number of replicates if bootstrap is used.}

\item{allowParallel}{Should the bootstrap procedure be run in parallel or not. Defaults to false.}

\item{numCores}{If allowParallel is true, specify the number of cores to use.}
}
\value{
statistic Test statistic.

p.value P-value for the test.

theta Estimated value of theta for the initial data.
}
\description{
Anderson-Darling goodness-of-fit test for the Generalized Pareto (GPD) distribution.
}
\details{
A table of critical values were generated via Monte Carlo simulation for shape
parameters -0.5 to 1.0 by 0.1, which provides p-values via log-linear interpolation from
.001 to .999. For p-values below .001, a linear equation exists by regressing -log(p-value)
on the critical values for the tail of the distribution (.950 to .999 upper percentiles). This
regression provides a method to extrapolate to arbitrarily small p-values.
}
\examples{
## Generate some data from GPD
x <- rgpd(200, loc = 0, scale = 1, shape = 0.2)
gpdAd(x)
}
\references{
Choulakian, V., & Stephens, M. A. (2001). Goodness-of-fit tests for the generalized Pareto distribution. Technometrics, 43(4), 478-484.
}

