% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_citations.r
\name{epmc_citations}
\alias{epmc_citations}
\title{Get citations for a given publication}
\usage{
epmc_citations(ext_id = NULL, data_src = "med", limit = 25,
  verbose = TRUE)
}
\arguments{
\item{ext_id}{character, publication identifier}

\item{data_src}{character, data source, by default Pubmed/MedLine index will
be searched.
The following three letter codes represent the sources
Europe PubMed Central supports:
\describe{
  \item{agr}{Agricola is a bibliographic database of citations to the
  agricultural literature created by the US National Agricultural Library
  and its co-operators.}
  \item{cba}{Chinese Biological Abstracts}
  \item{ctx}{CiteXplore}
  \item{eth}{EthOs Theses, i.e. PhD theses (British Library)}
  \item{hir}{NHS Evidence}
  \item{med}{PubMed/Medline NLM}
  \item{nbk}{Europe PMC Book metadata}
  \item{pat}{Biological Patents}
  \item{pmc}{PubMed Central}
  }}

\item{limit}{integer, number of results. By default, this function
returns 25 records.}

\item{verbose}{logical, print some information on what is going on.}
}
\value{
Metadata of citing documents as data.frame
}
\description{
Finds works that cite a given publication.
}
\examples{
\dontrun{
epmc_citations("PMC3166943", data_src = "pmc")
epmc_citations("9338777")
}
}

