% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{as.EurostatDataList}
\alias{as.EurostatDataList}
\title{Coerce a data.frame to a EurostatDataList}
\usage{
as.EurostatDataList(x, SearchCriteria = "", ...)
}
\arguments{
\item{x}{A (most likely filtered subset of) \code{EurostatDataList} data.frame
returned by \code{\link[eurodata]{importDataList}}.}

\item{SearchCriteria}{A string describing the search criteria used for
filtering/subsetting.}

\item{...}{Additional arguments to be passed to or from methods
(currently not used).}
}
\value{
A data.frame of S3 class \code{EurostatDataList}.
}
\description{
Some manipulations of the \code{EurostatDataList} data.frame
(imported with \code{\link[eurodata]{importDataList}})
e.g. filtering with package \pkg{dplyr} may remove the S3 class tag
\code{EurostatDataList}. This function coerces it back to \code{EurostatDataList}
after checking that the critical columns
(\code{PCode}, \code{Dataset name},\code{Link}) are present. This is useful
if a user wants to print and browse this filtered data.frame as a specially
formatted HTML table.
}
